/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.controllers.ClientCloneController;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiMenuSideButton;
import noppes.npcs.client.gui.util.GuiMenuTopButton;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.constants.EnumPacketServer;

public class GuiNpcMobSpawnerMounter
extends GuiNPCInterface
implements IGuiData {
    private static int showingClones = 0;
    private int activeTab = 1;
    private final int posX;
    private final int posY;
    private final int posZ;
    private GuiCustomScroll scroll;

    public GuiNpcMobSpawnerMounter(int x, int y, int z) {
        this.xSize = 256;
        this.closeOnEsc = true;
        this.setBackground("menubg.png");
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        switch (button.getID()) {
            case 0: {
                this.close();
                break;
            }
            case 1: {
                NBTTagCompound compound = this.getCompound();
                if (compound == null) break;
                compound.func_74782_a("Pos", (NBTBase)this.newDoubleNBTList((double)this.posX + 0.5, this.posY + 1, (double)this.posZ + 0.5));
                Client.sendData(EnumPacketServer.SpawnRider, compound);
                this.close();
                break;
            }
            case 2: {
                Client.sendData(EnumPacketServer.PlayerRider, new Object[0]);
                this.close();
                break;
            }
            case 3: {
                showingClones = 0;
                this.func_73866_w_();
                break;
            }
            case 4: {
                showingClones = 1;
                this.func_73866_w_();
                break;
            }
            case 5: {
                showingClones = 2;
                this.func_73866_w_();
                break;
            }
            default: {
                if (button.getID() <= 20) break;
                this.activeTab = button.getID() - 20;
                this.func_73866_w_();
            }
        }
    }

    private NBTTagCompound getCompound() {
        String sel = this.scroll.getSelected();
        if (sel == null) {
            return null;
        }
        if (showingClones == 0) {
            return ClientCloneController.Instance.getCloneData((ICommandSender)this.player, sel, this.activeTab);
        }
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(sel), (World)Minecraft.func_71410_x().field_71441_e);
        if (entity == null) {
            return null;
        }
        NBTTagCompound compound = new NBTTagCompound();
        entity.func_184198_c(compound);
        return compound;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiTop += 10;
        if (this.scroll == null) {
            this.scroll = new GuiCustomScroll(this, 0);
            this.scroll.setSize(165, 188);
        } else {
            this.scroll.clear();
        }
        this.scroll.guiLeft = this.guiLeft + 4;
        this.scroll.guiTop = this.guiTop + 26;
        this.addScroll(this.scroll);
        GuiMenuTopButton button = new GuiMenuTopButton(3, this.guiLeft + 4, this.guiTop - 17, "spawner.clones");
        button.active = showingClones == 0;
        this.addTopButton(button);
        button = new GuiMenuTopButton(4, button, "spawner.entities");
        button.active = showingClones == 1;
        this.addTopButton(button);
        button = new GuiMenuTopButton(5, button, "gui.server");
        button.active = showingClones == 2;
        this.addTopButton(button);
        this.addButton(new GuiNpcButton(1, this.guiLeft + 170, this.guiTop + 6, 82, 20, "spawner.mount"));
        this.addButton(new GuiNpcButton(2, this.guiLeft + 170, this.guiTop + 50, 82, 20, "spawner.mountplayer"));
        if (showingClones == 0 || showingClones == 2) {
            int x = this.guiLeft;
            int y = this.guiTop + 4;
            for (int id = 1; id < 10; ++id) {
                GuiMenuSideButton sideButton = new GuiMenuSideButton(20 + id, x, y + (id - 1) * 21, "Tab " + id);
                this.addSideButton(sideButton);
            }
            this.getSideButton(20 + this.activeTab).setActive(true);
            this.showClones();
        } else {
            this.showEntities();
        }
    }

    protected NBTTagList newDoubleNBTList(double ... par1ArrayOfDouble) {
        NBTTagList nbttaglist = new NBTTagList();
        for (double d1 : par1ArrayOfDouble) {
            nbttaglist.func_74742_a((NBTBase)new NBTTagDouble(d1));
        }
        return nbttaglist;
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        NBTTagList nbtList = compound.func_150295_c("List", 8);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            list.add(nbtList.func_150307_f(i));
        }
        this.scroll.setList(list);
    }

    private void showClones() {
        if (showingClones == 2) {
            Client.sendData(EnumPacketServer.CloneList, this.activeTab);
            return;
        }
        this.scroll.setList(ClientCloneController.Instance.getClones(this.activeTab));
    }

    private void showEntities() {
        ArrayList<String> list = new ArrayList<String>();
        for (EntityEntry ent : ForgeRegistries.ENTITIES.getValuesCollection()) {
            Class c = ent.getEntityClass();
            String name = ent.getName();
            try {
                if (!EntityLiving.class.isAssignableFrom(c) || Modifier.isAbstract(c.getModifiers())) continue;
                list.add(name);
            }
            catch (Exception e) {
                LogWriter.error(e);
            }
        }
        this.scroll.setList(list);
    }
}

